from rest_framework import status
from rest_framework.test import APITestCase
from rest_framework.test import force_authenticate
from rest_framework.test import APIClient  


# from api.models import ChatRoom


class ChatRoomTest(APITestCase):

    def test_login(self):
        self.url = '/api/v1/auth/login/'
        self.body = {
            "username": 'superuser',
            'password': 'password123'
        }
        request = self.client.post(self.url, self.body, format='multipart')
        print(request.json())

        self.access_token = request.json()['token']

        self.assertEqual(request.status_code, status.HTTP_200_OK)

    def test_companies(self):
        self.url = '/api/v1/master/companies/'
        self.client = APIClient()
        self.client.credentials(HTTP_AUTHORIZATION='Bearer ' + self.access_token)
        request = self.client.get(self.url, format='json')
        self.assertEqual(request.status_code, status.HTTP_200_OK)

